package gui.XML;
import java.io.*;
import java.util.Vector;
public class saveToXML {
	
	private static String targetState,availableState,action,availableService,composedStateSimulator,targetStateSimulated;
	private static String state="";
	private static String service="";
	private static char c;
	
	public static void saveCompositionXML(Vector<String[]> v,String fileName, boolean wantsStylesheet){
		try 
		{
			File file = new File(fileName+".xml"); 
			FileWriter fw = new FileWriter(file); 
			fw.write("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n");
			if(wantsStylesheet){
				fw.write("<?xml-stylesheet href=\""+fileName+".xsl\" type=\"text/xsl\"?>\n\n");
				saveCompositionXSL(fileName);
			}
			fw.write("<SetTransition>"+"\n");
			for(int j=0;j<v.size();j++){
				String[] transition=v.elementAt(j);
				targetState=transition[0];
				availableState=transition[1];
				action=transition[2];
				availableService=transition[3];
				fw.write("	<Transition>"+"\n");
				fw.write("		<InputState>"+"\n");
				fw.write("			<TargetState name="+"\""+targetState+"\"/>"+"\n");
				for(int i=0;i<availableState.length();i++){
					c=availableState.charAt(i);
					if (c!=','){
						state=state+c;
					}
					else{
						fw.write("			<AvailableState name="+"\""+state+"\"/>"+"\n");
						state="";
					}
				}
				fw.write("			<AvailableState name="+"\""+state+"\"/>"+"\n");
				state="";
				fw.write("			<Action name="+"\""+action+"\"/>"+"\n");
				fw.write("		</InputState>"+"\n");
				fw.write("		<SetAvailableService>"+"\n");	
				for(int i=0;i<availableService.length();i++){
					c=availableService.charAt(i);
					if (c!=','){
						service=service+c;
					}
					else{
						fw.write("			<AvailableService name="+"\""+service+"\"/>"+"\n");
						service="";
					}
				}
				fw.write("			<AvailableService name="+"\""+service+"\"/>"+"\n");
				service="";
				fw.write("		</SetAvailableService>"+"\n");
				fw.write("	</Transition>"+"\n");
			}
			fw.write("</SetTransition>"+"\n");
			
			fw.flush(); 
			fw.close();  
		}
		catch (IOException e) 
		{
			e.printStackTrace();
		}
	}
	
	public static void saveSimulationXML(Vector<String[]> v,String fileName, boolean wantsStylesheet){
		try 
		{
			File file = new File(fileName+".xml"); 
			FileWriter fw = new FileWriter(file); 
			fw.write("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n");
			if(wantsStylesheet){
				fw.write("<?xml-stylesheet href=\""+fileName+".xsl\" type=\"text/xsl\"?>\n\n");
				saveSimulationXSL(fileName);
			}
			fw.write("<SetSimulation>"+"\n");
			for(int j=0;j<v.size();j++){
				String[] transition=v.elementAt(j);
				targetStateSimulated=transition[0];
				composedStateSimulator=transition[1];
				fw.write("	<Simulation>"+"\n");
				fw.write("		<TargetStateSimulated name="+"\""+targetStateSimulated+"\"/>"+"\n");
				fw.write("		<ComposedStateSimulator name="+"\""+composedStateSimulator+"\"/>"+"\n");
				fw.write("	</Simulation>"+"\n");
			}
			fw.write("</SetSimulation>"+"\n");
			fw.flush(); 
			fw.close();  
		}
		catch (IOException e) 
		{
			e.printStackTrace();
		}
	}
	
	public static void saveCompositionXSL(String fileName){
		try 
		{
			File file = new File(fileName+".xsl"); 
			FileWriter fw = new FileWriter(file); 
			fw.write("<?xml version=\"1.0\"?>\n");
			fw.write("<xsl:stylesheet xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\" version=\"1.0\">\n"); 
			fw.write("<xsl:output method=\"html\"/>\n\n");
			fw.write("<xsl:template match=\"/SetTransition\">\n");
			fw.write("	<html>\n");
			fw.write("		<body>\n");
			fw.write("			<TABLE width=\"80%\" border=\"1\">\n");
			fw.write("				<CAPTION>\n");
			fw.write("					<DIV align=\"left\"><b>Composition Details</b></DIV>\n");
			fw.write("				</CAPTION>\n");
			fw.write("				<THEAD>\n");
			fw.write("					<TR>\n");
			fw.write("						<TH bgcolor=\"cyan\">Target System State</TH>\n");
			fw.write("						<TH bgcolor=\"lightgreen\">Available Services States</TH>\n");
			fw.write("						<TH bgcolor=\"red\">Action</TH>\n");
			fw.write("						<TH bgcolor=\"orange\">Available Services</TH>\n");
			fw.write("					</TR>\n");
			fw.write("				</THEAD>\n");
			fw.write("				<TBODY>\n");
			fw.write("					<xsl:apply-templates/>\n"); 
			fw.write("				</TBODY>\n");
			fw.write("			</TABLE>\n");
			fw.write("		</body>\n");
			fw.write("	</html>\n");
			fw.write("</xsl:template>\n\n");
			fw.write("<xsl:template match=\"/SetTransition/Transition\">\n");
			fw.write("	<TR>\n");
			fw.write("		<xsl:apply-templates select=\"InputState\"/>\n");
			fw.write("		<TD>\n");
			fw.write("			<xsl:apply-templates select=\"SetAvailableService\"/>\n");
			fw.write("		</TD>\n");
			fw.write("	</TR>\n");
			fw.write("</xsl:template>\n\n");
			fw.write("<xsl:template match=\"/SetTransition/Transition/InputState\">\n");
			fw.write("	<xsl:apply-templates select=\"TargetState\"/>\n"); 
			fw.write("	<TD>\n");
			fw.write("		<xsl:apply-templates select=\".//AvailableState\"/>\n");
			fw.write("	</TD>\n");
			fw.write("	<xsl:apply-templates select=\"Action\"/>\n");
			fw.write("</xsl:template>\n\n");
			fw.write("<xsl:template match=\"/SetTransition/Transition/InputState/TargetState\">\n");
			fw.write("	<TD><FONT color=\"blue\"><b><xsl:value-of select=\"@name\"/></b></FONT></TD>\n");
			fw.write("</xsl:template>\n\n");
			fw.write("<xsl:template match=\"/SetTransition/Transition/InputState/AvailableState\">\n");
			fw.write("	<FONT color=\"green\"><xsl:value-of select=\"@name\"/>,</FONT>\n");
			fw.write("</xsl:template>\n\n");
			fw.write("<xsl:template match=\"/SetTransition/Transition/InputState/AvailableState[last()]\">\n");
			fw.write("	<FONT color=\"green\"><xsl:value-of select=\"@name\"/></FONT>\n");
			fw.write("</xsl:template>\n\n");
			fw.write("<xsl:template match=\"/SetTransition/Transition/InputState/Action\">\n");
			fw.write("	<TD><FONT color=\"red\"><b><xsl:value-of select=\"@name\"/></b></FONT></TD>\n");
			fw.write("</xsl:template>\n\n");
			fw.write("<xsl:template match=\"/SetTransition/Transition/SetAvailableService\">\n");
			fw.write("	<FONT color=\"orange\"><xsl:apply-templates/> </FONT>\n");
			fw.write("</xsl:template>\n\n");
			
			fw.write("<xsl:template match=\"/SetTransition/Transition/SetAvailableService/AvailableService\">\n");
			fw.write("	<xsl:value-of select=\"@name\"/>,\n");
			fw.write("</xsl:template>\n\n");
			fw.write("<xsl:template match=\"/SetTransition/Transition/SetAvailableService/AvailableService[last()]\">\n");
			fw.write("	<xsl:value-of select=\"@name\"/>\n");
			fw.write("</xsl:template>\n\n");
			fw.write("</xsl:stylesheet>\n");
			fw.flush(); 
			fw.close();  
		}
		catch (IOException e) 
		{
			e.printStackTrace();
		}
	}
	
	public static void saveSimulationXSL(String fileName){
		try 
		{
			File file = new File(fileName+".xsl"); 
			FileWriter fw = new FileWriter(file); 
			fw.write("<?xml version=\"1.0\"?>\n");
			fw.write("<xsl:stylesheet xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\" version=\"1.0\">\n"); 
			fw.write("<xsl:output method=\"html\"/>\n\n");
			fw.write("<xsl:template match=\"/SetSimulation\">\n");
			fw.write("	<html>\n");
			fw.write("		<body>\n");
			fw.write("			<TABLE width=\"40%\" border=\"1\">\n");
			fw.write("				<CAPTION>\n");
			fw.write("					<DIV align=\"left\"><b>Simulation Details</b></DIV>\n");
			fw.write("				</CAPTION>\n");
			fw.write("				<THEAD>\n");
			fw.write("					<TR>\n");
			fw.write("						<TH bgcolor=\"cyan\">Target State Simulated</TH>\n");
			fw.write("						<TH bgcolor=\"lightgreen\">Composed State Simulator</TH>\n");
			fw.write("					</TR>\n");
			fw.write("				</THEAD>\n");
			fw.write("				<TBODY>\n");
			fw.write("					<xsl:apply-templates/>\n"); 
			fw.write("				</TBODY>\n");
			fw.write("			</TABLE>\n");
			fw.write("		</body>\n");
			fw.write("	</html>\n");
			fw.write("</xsl:template>\n\n");
			fw.write("<xsl:template match=\"/SetSimulation/Simulation\">\n");
			fw.write("	<TR>\n");
			fw.write("		<xsl:apply-templates/>\n");
			fw.write("	</TR>\n");
			fw.write("</xsl:template>\n\n");
			fw.write("<xsl:template match=\"/SetSimulation/Simulation/TargetStateSimulated\">\n");
			fw.write("	<TD><FONT color=\"blue\"><b><xsl:value-of select=\"@name\"/></b></FONT></TD>\n");
			fw.write("</xsl:template>\n\n");
			fw.write("<xsl:template match=\"/SetSimulation/Simulation/ComposedStateSimulator\">\n");
			fw.write("	<TD><FONT color=\"green\"><xsl:value-of select=\"@name\"/></FONT></TD>\n");
			fw.write("</xsl:template>\n\n");
			fw.write("</xsl:stylesheet>\n");
			fw.flush(); 
			fw.close();  
		}
		catch (IOException e) 
		{
			e.printStackTrace();
		}
	}
	
}

	
